<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;

class Vendor extends Model 
{

    protected $table = 'vendors';
    public $timestamps = true;
    protected $fillable = array('name', 'name_en', 'img', 'phone', 'email', 'text', 'response', 'user_id', 'activity');

    public function locations()
    {
        return $this->hasMany('App\models\Location');
    }

    public function categories()
    {
        return $this->hasMany('App\models\Category');
    }

}